import React from "react";
import { Routes, Route, NavLink, Link } from "react-router-dom";
import ProductList from "./pages/ProductList";
import AddEditProduct from "./pages/AddEditProduct";

export default function App() {
  return (
    <div className="min-h-screen flex flex-col bg-gradient-to-br from-gray-50 via-slate-100 to-gray-200 text-gray-800">
      {/* Navbar */}
      <header className="bg-gradient-to-r from-sky-600 to-indigo-600 shadow-md text-white">
        <div className="max-w-6xl mx-auto flex justify-between items-center px-6 py-4">
          <h1 className="text-2xl font-bold tracking-tight">
            Product Catalog
          </h1>
          <nav className="flex items-center gap-6 text-sm font-medium">
            <NavLink
              to="/"
              className={({ isActive }) =>
                `transition-colors ${
                  isActive
                    ? "text-white border-b-2 border-white pb-1"
                    : "text-gray-100 hover:text-white"
                }`
              }
            >
              Products
            </NavLink>
            <NavLink
              to="/add"
              className={({ isActive }) =>
                `transition-colors ${
                  isActive
                    ? "text-white border-b-2 border-white pb-1"
                    : "text-gray-100 hover:text-white"
                }`
              }
            >
              Add Product
            </NavLink>
          </nav>
        </div>
      </header>

      {/* Main Content */}
      <main className="flex-1">
        <div className="max-w-6xl mx-auto px-6 py-10">
          <div className="bg-white/80 backdrop-blur-md rounded-3xl shadow-sm border border-gray-100 p-6 sm:p-10">
            <Routes>
              <Route path="/" element={<ProductList />} />
              <Route path="/add" element={<AddEditProduct />} />
              <Route path="/edit/:id" element={<AddEditProduct />} />
            </Routes>
          </div>
        </div>
      </main>

      {/* Floating Add Button */}
      <Link
        to="/add"
        className="fixed bottom-6 right-6 bg-sky-600 hover:bg-sky-700 text-white shadow-lg rounded-full w-10 h-10 flex items-center justify-center text-xl"
        title="Add Product"
      >
        +
      </Link>
    </div>
  );
}
