import express from "express";
import multer from "multer";
import Product from "../models/Product.js";
import path from "path";

const router = express.Router();

// Configure Multer
const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, "uploads/");
  },
  filename: (req, file, cb) => {
    const unique = Date.now() + path.extname(file.originalname);
    cb(null, unique);
  },
});
const upload = multer({ storage });

// GET all products
router.get("/", async (req, res) => {
  const products = await Product.find().sort({ createdAt: -1 });
  res.json(products);
});

// ADD product
router.post("/", upload.single("image"), async (req, res) => {
  const imageUrl = req.file ? `/uploads/${req.file.filename}` : "";
  const product = new Product({ ...req.body, image: imageUrl });
  await product.save();
  res.json(product);
});

// UPDATE product
router.put("/:id", upload.single("image"), async (req, res) => {
  const existing = await Product.findById(req.params.id);
  let imageUrl = existing.image;
  if (req.file) imageUrl = `/uploads/${req.file.filename}`;
  const updated = await Product.findByIdAndUpdate(
    req.params.id,
    {
      ...req.body,
      image: imageUrl,
    },
    { new: true }
  );
  res.json(updated);
});

// DELETE product
router.delete("/:id", async (req, res) => {
  await Product.findByIdAndDelete(req.params.id);
  res.json({ success: true });
});

export default router;
