const express = require('express');
const router = express.Router();
const Expense = require('../models/Expense');

// GET /api/expenses
router.get('/', async (req, res) => {
  try {
    const { category, from, to, q } = req.query;
    const filter = {};
    if (category) filter.category = category;
    if (from || to) filter.date = {};
    if (from) filter.date.$gte = new Date(from);
    if (to) filter.date.$lte = new Date(to);
    if (q) filter.title = { $regex: q, $options: 'i' };
    const expenses = await Expense.find(filter).sort({ date: -1 });
    res.json(expenses);
  } catch(err) { res.status(500).json({ error: err.message }); }
});

// POST /api/expenses
router.post('/', async (req, res) => {
  try {
    const { title, amount, category, date } = req.body;
    const expense = new Expense({ title, amount, category, date });
    await expense.save();
    res.status(201).json(expense);
  } catch(err) { res.status(400).json({ error: err.message }); }
});

// PUT /api/expenses/:id
router.put('/:id', async (req, res) => {
  try {
    const updated = await Expense.findByIdAndUpdate(req.params.id, req.body, { new: true });
    if (!updated) return res.status(404).json({ error: 'Not found' });
    res.json(updated);
  } catch(err) { res.status(400).json({ error: err.message }); }
});

// DELETE /api/expenses/:id
router.delete('/:id', async (req, res) => {
  try {
    const removed = await Expense.findByIdAndDelete(req.params.id);
    if (!removed) return res.status(404).json({ error: 'Not found' });
    res.json({ success: true });
  } catch(err) { res.status(500).json({ error: err.message }); }
});

module.exports = router;
