import React from 'react'
import { Routes, Route, NavLink } from 'react-router-dom'
import Dashboard from './pages/Dashboard'
import ExpenseForm from './pages/AddEditExpense'
import ExpenseList from './pages/ExpenseList'

export default function App() {
  return (
    <div className="min-h-screen flex flex-col bg-gray-100 text-gray-800">
      {/* Navbar */}
      <header className="bg-white shadow-sm border-b border-gray-200">
        <div className="max-w-6xl mx-auto px-6 py-3 flex justify-between items-center">
          <h1 className="text-2xl font-bold text-sky-500 tracking-tight">
            Expense Tracker
          </h1>
          <nav className="flex items-center gap-6 text-sm font-medium">
            <NavLink
              to="/"
              className={({ isActive }) =>
                `transition-colors hover:text-sky-600 ${
                  isActive ? 'text-sky-500 font-semibold' : 'text-gray-600'
                }`
              }
            >
              Dashboard
            </NavLink>
            <NavLink
              to="/expenses"
              className={({ isActive }) =>
                `transition-colors hover:text-sky-600 ${
                  isActive ? 'text-sky-500 font-semibold' : 'text-gray-600'
                }`
              }
            >
              Expenses
            </NavLink>
            <NavLink
              to="/add"
              className={({ isActive }) =>
                `transition-colors hover:text-sky-600 ${
                  isActive ? 'text-sky-500 font-semibold' : 'text-gray-600'
                }`
              }
            >
              Add
            </NavLink>
          </nav>
        </div>
      </header>

      {/* Main Content */}
      <main className="flex-1">
        <div className="max-w-6xl mx-auto px-6 py-8">
          <div className="bg-white shadow-sm rounded-2xl p-6 border border-gray-100">
            <Routes>
              <Route path="/" element={<Dashboard />} />
              <Route path="/expenses" element={<ExpenseList />} />
              <Route path="/add" element={<ExpenseForm />} />
              <Route path="/edit/:id" element={<ExpenseForm />} />
            </Routes>
          </div>
        </div>
      </main>

      {/* Footer */}
      <footer className="text-center text-sm text-gray-500 py-4 border-t border-gray-200">
        © {new Date().getFullYear()} Expense Tracker. All rights reserved.
      </footer>
    </div>
  )
}
