import { useEffect, useState } from "react";
import axios from "axios";
import { Link } from "react-router-dom";
import BookCard from "../components/BookCard";

const Home = () => {
  const [books, setBooks] = useState([]);

  const fetchBooks = async () => {
    const res = await axios.get("http://localhost:5000/api/books");
    setBooks(res.data);
  };

  const handleDelete = async (id) => {
    await axios.delete(`http://localhost:5000/api/books/${id}`);
    fetchBooks();
  };

  useEffect(() => {
    fetchBooks();
  }, []);

  return (
    <div className="min-h-screen">
      {/* Header */}
      <div className="max-w-6xl mx-auto flex flex-col sm:flex-row justify-between items-center mb-10 bg-white/70 backdrop-blur-md border border-gray-200 rounded-2xl p-6 shadow-sm">
        <h1 className="text-4xl font-bold text-gray-900 capitalize tracking-tight text-center sm:text-left">
          📚 Book Collection
        </h1>
        <Link
          to="/add"
          className="mt-4 sm:mt-0 bg-gradient-to-r from-blue-600 to-blue-500 text-white px-6 py-2.5 rounded-xl shadow-md hover:shadow-lg hover:scale-[1.03] transition-transform"
        >
          + Add Book
        </Link>
      </div>

      {/* Book Grid */}
      <div className="max-w-6xl mx-auto">
        {books.length === 0 ? (
          <div className="text-center mt-20">
            <p className="text-gray-600 text-lg">No books added yet.</p>
            <Link
              to="/add"
              className="inline-block mt-6 bg-blue-600 text-white px-5 py-2 rounded-lg hover:bg-blue-700 transition"
            >
              Add Your First Book
            </Link>
          </div>
        ) : (
          <div className="grid sm:grid-cols-2 lg:grid-cols-3 gap-8">
            {books.map((book) => (
              <BookCard key={book._id} book={book} onDelete={handleDelete} />
            ))}
          </div>
        )}
      </div>
    </div>
  );
};

export default Home;
