import { Link, useLocation } from "react-router-dom";

const Navbar = () => {
  const location = useLocation();

  return (
    <nav className="sticky top-0 z-50 backdrop-blur-lg bg-white/70 border-b border-gray-200 shadow-sm">
      <div className="max-w-6xl mx-auto px-4 py-3 flex justify-between items-center">
        {/* Logo / Brand */}
        <Link
          to="/"
          className="flex items-center gap-2 text-2xl font-semibold text-gray-900 hover:opacity-90 transition-opacity"
        >
          📚 <span className="bg-gradient-to-r from-blue-600 to-blue-500 text-transparent bg-clip-text">Book Collection</span>
        </Link>

        {/* Navigation Links */}
        <div className="flex items-center space-x-6 text-gray-700 font-medium">
          <Link
            to="/"
            className={`hover:text-blue-600 transition ${
              location.pathname === "/" ? "text-blue-600 font-semibold" : ""
            }`}
          >
            Home
          </Link>
          <Link
            to="/add"
            className={`hover:text-blue-600 transition ${
              location.pathname === "/add" ? "text-blue-600 font-semibold" : ""
            }`}
          >
            Add Book
          </Link>
        </div>
      </div>
    </nav>
  );
};

export default Navbar;
