import { Link } from "react-router-dom";

const BookCard = ({ book, onDelete }) => {
  return (
    <div className="group relative bg-white/80 backdrop-blur-sm border border-gray-100 shadow-sm hover:shadow-lg rounded-2xl transition-all duration-300 hover:-translate-y-1">
      {/* Gradient Header */}
      <div className="h-2 w-full bg-gradient-to-r from-blue-500 via-purple-500 to-pink-500 rounded-t-2xl"></div>

      <div className="p-5 flex flex-col h-full">
        {/* Title & Author */}
        <div className="mb-3">
          <h2 className="text-xl font-semibold text-gray-900 group-hover:text-blue-600 transition">
            {book.title}
          </h2>
          <p className="text-sm text-gray-500 mt-1">by {book.author}</p>
        </div>

        {/* Description */}
        <p className="text-gray-700 text-sm leading-relaxed flex-grow">
          {book.description
            ? book.description.length > 100
              ? `${book.description.slice(0, 100)}...`
              : book.description
            : "No description available."}
        </p>

        {/* Action Buttons */}
        <div className="flex justify-end gap-3 mt-5">
          <Link
            to={`/edit/${book._id}`}
            className="px-4 py-1.5 text-sm rounded-lg bg-gradient-to-r from-yellow-400 to-yellow-500 text-white font-medium shadow hover:shadow-md hover:scale-105 transition-transform"
          >
            Edit
          </Link>
          <button
            onClick={() => onDelete(book._id)}
            className="px-4 py-1.5 text-sm rounded-lg bg-gradient-to-r from-red-500 to-red-600 text-white font-medium shadow hover:shadow-md hover:scale-105 transition-transform"
          >
            Delete
          </button>
        </div>
      </div>
    </div>
  );
};

export default BookCard;
