import React from "react";
import { useNavigate } from "react-router-dom";

const Home = () => {
  const navigate = useNavigate();

  return (
    <div className="min-h-screen flex flex-col justify-center items-center bg-gradient-to-br from-indigo-700 via-purple-800 to-blue-900 text-white">
      <h1 className="text-5xl font-bold mb-6">🧩 Word Search Quest</h1>
      <p className="text-lg mb-10 text-blue-200">
        Find all the hidden words — test your brain!
      </p>

      <button
        onClick={() => navigate("/game")}
        className="bg-yellow-500 text-black font-bold text-lg px-6 py-3 rounded-xl hover:bg-yellow-400 transition-all"
      >
        Start Game
      </button>
    </div>
  );
};

export default Home;
