
var express = require('express');
var router = express.Router();
const authMiddleware = require('../middleware/auth');
const { register, login} = require('../controllers/authControll');

router.post('/register', register);
router.post('/login', login);

router.get('/user', authMiddleware('user'), (req, res) => {
  res.send('Welcome User');
});

router.get('/seller', authMiddleware('seller'), (req, res) => {
  res.send('Welcome Seller');
});

router.get('/admin', authMiddleware('admin'), (req, res) => {
  res.send('Welcome Admin');
});

module.exports = router;
