const { User } = require("../model/User");
const jwt = require("jsonwebtoken");
const bcrypt = require("bcryptjs");

const createToken = (user) =>
  jwt.sign({ id: user._id, role: user.role }, process.env.JWT_SECRET, {
    expiresIn: "1d",
  });

const register = async (req, res) => {
  try {
    const { username, email, password, role } = req.body;

    // Optional: Check if email exists
    const existingUser = await User.findOne({ email });
    if (existingUser) {
      return res.status(400).json({ message: "Email already exists" });
    }

    const user = await User.create({ username, email, password, role });

    const token = createToken(user);

    res.json({
      message: "User registered successfully",
      token,
      user: { username: user.username, role: user.role }
    });
  } catch (err) {
    console.error("Register error:", err);
    res.status(400).json({ message: "Error", error: err.message });
  }
};



const login = async (req, res) => {
  try {
    const { email, password } = req.body;
    const user = await User.findOne({ email });

    if (!user)
      return res.status(400).json({ message: "Invalid email or password" });

    const isMatch = await bcrypt.compare(password, user.password);
    if (!isMatch)
      return res.status(400).json({ message: "Invalid email or password" });

    const token = createToken(user);
    res.json({
      token,
      user: { username: user.username, role: user.role },
    });
  } catch (err) {
    res.status(400).json({ message: "Login failed", error: err.message });
  }
};

module.exports = { register, login };
