import React from "react";
import { BrowserRouter, Route, Routes } from "react-router-dom";
import Register from "./pages/Register";
import Login from "./pages/Login";
import { Dashboard } from "./pages/Dashboard";
import { PrivateRoute } from "./utils/PrivateRoute";
import { AdminPage } from "./pages/AdminPage";
import { SellerPage } from "./pages/SellerPage";
import { UserPage } from "./pages/UserPage";

export const App = () => {
  return (
    <>
      <BrowserRouter>
        <Routes>
          <Route path="/register" element={<Register />} />
          <Route path="/" element={<Login />} />
          <Route path="/dashboard" element={<Dashboard />} />

          <Route
            path="/admin"
            element={
              <PrivateRoute roles={["admin"]}>
                <AdminPage />
              </PrivateRoute>
            }
          />

          <Route
            path="/seller"
            element={
              <PrivateRoute roles={["seller"]}>
                <SellerPage />
              </PrivateRoute>
            }
          />

          <Route
            path="/user"
            element={
              <PrivateRoute roles={["user"]}>
                <UserPage />
              </PrivateRoute>
            }
          />
        </Routes>
      </BrowserRouter>
    </>
  );
};
