import { motion } from "framer-motion";

export default function Card({ emoji, flipped, onClick, matched }) {
  return (
    <motion.div
      onClick={onClick}
      className={`w-20 h-20 sm:w-24 sm:h-24 rounded-xl cursor-pointer flex items-center justify-center text-3xl sm:text-4xl font-bold shadow-lg ${
        matched ? "bg-green-400" : "bg-white/20 backdrop-blur-sm"
      }`}
      whileTap={{ scale: 0.9 }}
      animate={{ rotateY: flipped ? 180 : 0 }}
      transition={{ duration: 0.5 }}
    >
      {flipped || matched ? emoji : "❓"}
    </motion.div>
  );
}
