// Shared JS for calculators (keeps logic in browser for responsiveness)

// BASIC
(function(){
  const display = document.getElementById('display');
  if(display){
    document.querySelectorAll('.basic-keys button').forEach(btn=>{
      btn.addEventListener('click', ()=> {
        const a = btn.dataset.action;
        if(a==='clear'){ display.value=''; return; }
        if(a==='back'){ display.value = display.value.slice(0,-1); return; }
        if(a==='equals'){ try{ display.value = eval(display.value) }catch(e){ display.value='Error' } return; }
        display.value += btn.textContent.trim();
      });
    });
  }
})();

// SCIENTIFIC
(function(){
  const sdisplay = document.getElementById('s-display');
  if(!sdisplay) return;
  document.querySelectorAll('.scientific-keys button').forEach(btn=>{
    btn.addEventListener('click', ()=> {
      const fn = btn.dataset.fn, a = btn.dataset.action;
      if(a==='clear'){ sdisplay.value=''; return; }
      if(a==='equals'){ try{ sdisplay.value = eval(sdisplay.value) }catch(e){ sdisplay.value='Error' } return; }
      if(fn){
        const x = parseFloat(sdisplay.value) || 0;
        let out = null;
        if(fn==='sin') out = Math.sin(x);
        if(fn==='cos') out = Math.cos(x);
        if(fn==='tan') out = Math.tan(x);
        if(fn==='log') out = Math.log10(x);
        if(fn==='sqrt') out = Math.sqrt(x);
        sdisplay.value = (out===null)?'Error':String(out);
        return;
      }
      sdisplay.value += btn.textContent.trim();
    });
  });
})();

// GRAPHING
(function(){
  const plotBtn = document.getElementById('plot-btn');
  if(!plotBtn) return;
  plotBtn.addEventListener('click', ()=> {
    const expr = document.getElementById('func-input').value || 'Math.sin(x)';
    const xs = [], ys = [];
    for(let i=-10;i<=10;i+=0.2){ xs.push(i); try{ ys.push(eval(expr)); }catch(e){ ys.push(null); } }
    if(typeof Plotly !== 'undefined'){ Plotly.newPlot('plot', [{x:xs,y:ys, mode:'lines'}], {margin:{t:10}}); }
  });
})();

// FINANCIAL (mortgage)
(function(){
  const btn = document.getElementById('calc-mortgage');
  if(!btn) return;
  btn.addEventListener('click', ()=> {
    const P = parseFloat(document.getElementById('principal').value)||0;
    const r = parseFloat(document.getElementById('rate').value)/100/12||0;
    const n = (parseFloat(document.getElementById('years').value)||0)*12;
    const M = (r===0)? (P/n) : P * r * Math.pow(1+r,n)/(Math.pow(1+r,n)-1);
    document.getElementById('mortgage-result').textContent = 'Monthly: ' + (isFinite(M)?M.toFixed(2):'—');
  });
})();

// PRINTING (simple)
(function(){
  const btn = document.getElementById('sum-print');
  if(!btn) return;
  btn.addEventListener('click', ()=> {
    const a = parseFloat(document.getElementById('a').value)||0;
    const b = parseFloat(document.getElementById('b').value)||0;
    const area = document.getElementById('print-area');
    area.style.display='block';
    area.innerHTML = '<h4>Result</h4><p>' + (a+b) + '</p>';
    window.print();
  });
})();

// SPECIALIZED (BMI & unit)
(function(){
  const bmi = document.getElementById('bmi-calc');
  if(bmi) bmi.addEventListener('click', ()=> {
    const w = parseFloat(document.getElementById('weight').value), h = parseFloat(document.getElementById('height').value);
    if(!w||!h){ document.getElementById('bmi-result').textContent='Enter valid numbers'; return; }
    document.getElementById('bmi-result').textContent = 'BMI: ' + (w/(h*h)).toFixed(2);
  });
  const uc = document.getElementById('uc-run');
  if(uc) uc.addEventListener('click', ()=> {
    const v = parseFloat(document.getElementById('uc-val').value), dir = document.getElementById('uc-dir').value;
    if(isNaN(v)){ document.getElementById('uc-result').textContent='Enter a number'; return; }
    document.getElementById('uc-result').textContent = dir==='m2ft'? (v+' m = '+(v*3.28084).toFixed(4)+' ft') : (v+' ft = '+(v*0.3048).toFixed(4)+' m');
  });
})();
