import React from 'react'
import TransactionCard from './TransactionCard'

export default function TransactionList({ items, onDelete }) {
  if (!items || items.length === 0) return <div className="text-center text-gray-500 dark:text-gray-400 p-6">No transactions yet</div>

  return (
    <div className="space-y-3">
      {items.map(i => <TransactionCard key={i.id} t={i} onDelete={onDelete} />)}
    </div>
  )
}
