import React from 'react'
import { motion } from 'framer-motion'

const colors = {
  Food: 'bg-orange-200 text-orange-700',
  Travel: 'bg-blue-200 text-blue-700',
  Bills: 'bg-yellow-200 text-yellow-700',
  Shopping: 'bg-pink-200 text-pink-700',
  Entertainment: 'bg-violet-200 text-violet-700',
  Salary: 'bg-green-200 text-green-700',
  Health: 'bg-red-200 text-red-700',
  General: 'bg-gray-200 text-gray-700'
}

export default function TransactionCard({ t, onDelete }) {
  const cls = colors[t.category] || colors.General
  return (
    <motion.div layout initial={{ opacity: 0, y: 6 }} animate={{ opacity: 1, y: 0 }} exit={{ opacity: 0, y: 6 }} className="flex items-center justify-between p-3 rounded-lg bg-white dark:bg-[#021427] border dark:border-slate-700 shadow-sm">
      <div className="flex items-start gap-3">
        <div className={`${cls} px-3 py-1 rounded-full text-sm font-semibold`}>{t.category}</div>
        <div>
          <div className="font-semibold">{t.title}</div>
          <div className="text-sm text-gray-500 dark:text-gray-400">{t.note || ''} {t.date ? ' • ' + t.date : ''}</div>
        </div>
      </div>
      <div className="flex items-center gap-3">
        <div className={`font-bold ${t.amount < 0 ? 'text-red-500' : 'text-green-500'}`}>₹{Math.abs(t.amount)}</div>
        <button onClick={() => onDelete(t.id)} className="px-3 py-1 rounded bg-red-500 text-white">Delete</button>
      </div>
    </motion.div>
  )
}
