import React from 'react'
import { motion } from 'framer-motion'

export default function ThemeToggle({ theme, setTheme }) {
  return (
    <button
      onClick={() => setTheme(theme === 'dark' ? 'light' : 'dark')}
      className="flex items-center gap-3 p-2 rounded-md border hover:bg-gray-100 dark:hover:bg-white/5"
    >
      <motion.div
        initial={{ rotate: 0 }}
        animate={{ rotate: theme === 'dark' ? 180 : 0 }}
        transition={{ duration: 0.5 }}
      >
        {theme === 'dark' ? '🌙' : '☀️'}
      </motion.div>
      <span className="hidden sm:inline text-sm">{theme === 'dark' ? 'Dark' : 'Light'}</span>
    </button>
  )
}
