import React from 'react'

export default function SummaryCard({ title, value, positive, negative }) {
  const cls = positive ? 'text-green-500' : negative ? 'text-red-500' : 'text-gray-800 dark:text-gray-100'
  return (
    <div className="p-4 rounded-lg bg-white dark:bg-[#021427] shadow-sm border dark:border-slate-700">
      <div className="text-sm text-gray-500 dark:text-gray-400">{title}</div>
      <div className={`text-2xl font-bold ${cls}`}>₹{Number(value || 0).toLocaleString()}</div>
    </div>
  )
}
