import React from "react";
import ThemeToggle from "./ThemeToggle";

export default function Navbar({ theme, setTheme }) {
  return (
    <header className="w-full bg-white/70 dark:bg-[#021427]/80 backdrop-blur sticky top-0 z-40 shadow-sm border-b border-slate-200 dark:border-slate-800 transition-all">
      <div className="max-w-6xl mx-auto px-4 py-3 flex items-center justify-between">
        {/* Logo */}
        <div className="flex items-center gap-3">
          <div className="w-10 h-10 rounded-lg bg-gradient-to-br from-indigo-500 to-purple-400 flex items-center justify-center text-white font-bold shadow-md">
            BP
          </div>
          <div>
            <h1 className="text-lg font-semibold text-slate-800 dark:text-white">
              BudgetPro
            </h1>
            <p className="text-xs text-slate-500 dark:text-slate-300">
              Smart Expense Tracker
            </p>
          </div>
        </div>

        {/* Right section */}
        <div className="flex items-center gap-3">
          <ThemeToggle theme={theme} setTheme={setTheme} />
        </div>
      </div>
    </header>
  );
}
