import React, { useEffect, useState } from 'react'
import Navbar from './components/Navbar'
import Dashboard from './components/Dashboard'

export default function App() {
  const [theme, setTheme] = useState(() => localStorage.getItem('finflow_theme') || 'light')

  useEffect(() => {
    const html = document.documentElement
    if (theme === 'dark') html.classList.add('dark')
    else html.classList.remove('dark')
    localStorage.setItem('finflow_theme', theme)
  }, [theme])

  return (
    <div className="min-h-screen">
      <Navbar theme={theme} setTheme={setTheme} />
      <main className="max-w-6xl mx-auto p-4 sm:p-6">
        <Dashboard />
      </main>
    </div>
  )
}
